// EncodePropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc580.h"
#include "EncodePropertyDlg.h"
#include "afxdialogex.h"
#include "sc580Dlg.h"

// CEncodePropertyDlg dialog

CEncodePropertyDlg::CEncodePropertyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEncodePropertyDlg::IDD, pParent)
{

}

void CEncodePropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_Profile, m_combol_profile);
	DDX_Control(pDX, IDC_COMBO_Entropy, m_combol_entropy);
	DDX_Control(pDX, IDC_COMBO_LEVEL, m_combol_level);
}


BEGIN_MESSAGE_MAP(CEncodePropertyDlg, CDialog)
END_MESSAGE_MAP()


// CEncodePropertyDlg message handlers


void CEncodePropertyDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	sc580Dlg* m_pMainDialog = (sc580Dlg*)AfxGetMainWnd();

	ULONG nChannelNum = m_pMainDialog->m_nCurSelectChannelNumber;

	ULONG m_level = 41;

		switch(m_combol_level.GetCurSel())
		{
			case 0:
				m_pMainDialog->m_nLevel = 0;
				m_level = 10;
				break;
			case 1:
				m_pMainDialog->m_nLevel = 1;
				m_level = 9;
				break;
			case 2:
				m_pMainDialog->m_nLevel = 2;
				m_level = 11;
				break;
			case 3:
				m_pMainDialog->m_nLevel = 3;
				m_level = 12;
				break;
			case 4:
				m_pMainDialog->m_nLevel = 4;
				m_level = 13;
				break;
			case 5:
				m_pMainDialog->m_nLevel = 5;
				m_level = 20;
				break;
			case 6:
				m_pMainDialog->m_nLevel = 6;
				m_level = 21;
				break;
			case 7:
				m_pMainDialog->m_nLevel = 7;
				m_level = 22;
				break;
			case 8:
				m_pMainDialog->m_nLevel = 8;
				m_level = 30;
				break;
			case 9:
				m_pMainDialog->m_nLevel = 9;
				m_level = 31;
				break;
			case 10:
				m_pMainDialog->m_nLevel = 10;
				m_level = 32;
				break;
			case 11:
				m_pMainDialog->m_nLevel = 11;
				m_level = 40;
				break;
			case 12:
				m_pMainDialog->m_nLevel = 12;
				m_level = 41;
				break;
			case 13:
				m_pMainDialog->m_nLevel = 13;
				m_level = 42;
				break;
			case 14:
				m_pMainDialog->m_nLevel = 14;
				m_level = 50;
				break;
			case 15:
				m_pMainDialog->m_nLevel = 15;
				m_level = 51;
				break;
		}

	QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0, 0xe, m_level);

	m_pMainDialog->m_nProfile = m_combol_profile.GetCurSel();

	m_pMainDialog->m_nEntropy = m_combol_entropy.GetCurSel();

	QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( m_pMainDialog->m_hVideoDevice[ nChannelNum ], 0, 0xb, m_combol_profile.GetCurSel());

	QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( m_pMainDialog->m_hVideoDevice[nChannelNum ], 0, 0xf, m_combol_entropy.GetCurSel());

	CDialog::OnOK();
}

void CEncodePropertyDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CEncodePropertyDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	sc580Dlg* m_pMainDialog = (sc580Dlg*)AfxGetMainWnd();

	//
	m_combol_profile.InsertString(0,_T("HIGH"));
	m_combol_profile.InsertString(1,_T("BASELINE"));
	m_combol_profile.InsertString(2,_T("MAIN"));
	m_combol_profile.SetCurSel(m_pMainDialog->m_nProfile);

	//
	m_combol_entropy.InsertString(0,_T("CABAC"));
	m_combol_entropy.InsertString(1,_T("CAVLC"));
	m_combol_entropy.SetCurSel(m_pMainDialog->m_nEntropy);

	//
	m_combol_level.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_level.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_level.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_level.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_level.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_level.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_level.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_level.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_level.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_level.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_level.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_level.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_level.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_level.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_level.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_level.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_level.SetCurSel(m_pMainDialog->m_nLevel);

	return TRUE; 
}